/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigURLTemplatePanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VWConfigURLTemplateDialog
extends VWModalDialog
implements ActionListener {
    private VWConfigURLTemplatePanel m_lspURLTemplatePanel = null;
    private VWConfigURLTemplatePanel m_spURLTemplatePanel = null;
    private JButton m_OKButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private int m_nRetStatus = -1;
    private boolean m_bIsDirty = false;

    public VWConfigURLTemplateDialog(Dialog parent, VWAttributeInfo vwAttributeInfo, VWSessionInfo sessionInfo) {
        super(parent);
        this.m_vwAttributeInfo = vwAttributeInfo;
        this.setTitle(VWResource.URLTemplates);
        Dimension dim = VWStringUtils.stringToDimension("775, 445");
        if (dim == null) {
            dim = new Dimension(700, 400);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)this.createURLTemplatesPanel(this, sessionInfo), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.setLocationRelativeTo(parent);
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_bIsDirty;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            try {
                this.m_nRetStatus = 1;
                this.setVisible(false);
            }
            catch (Exception ex) {}
        } else if (obj == this.m_OKButton) {
            try {
                if (!this.m_lspURLTemplatePanel.update()) {
                    return;
                }
                if (this.m_lspURLTemplatePanel.hasChanged()) {
                    this.m_bIsDirty = true;
                }
                if (!this.m_spURLTemplatePanel.update()) {
                    return;
                }
                if (this.m_spURLTemplatePanel.hasChanged()) {
                    this.m_bIsDirty = true;
                }
                this.m_nRetStatus = 0;
                this.setVisible(false);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_error, 0);
                return;
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc073.htm");
        }
    }

    public void releaseResources() {
        if (this.m_lspURLTemplatePanel != null) {
            this.m_lspURLTemplatePanel.releaseResources();
            this.m_lspURLTemplatePanel = null;
        }
        if (this.m_spURLTemplatePanel != null) {
            this.m_spURLTemplatePanel.releaseResources();
            this.m_spURLTemplatePanel = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_vwAttributeInfo = null;
        this.removeAll();
    }

    private JPanel createURLTemplatesPanel(Dialog parent, VWSessionInfo sessionInfo) {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 1;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.5;
            gbConst.insets = new Insets(4, 10, 10, 0);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            this.m_lspURLTemplatePanel = new VWConfigURLTemplatePanel(parent, this.m_vwAttributeInfo, sessionInfo, 1);
            panel.add((Component)this.m_lspURLTemplatePanel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            this.m_spURLTemplatePanel = new VWConfigURLTemplatePanel(parent, this.m_vwAttributeInfo, sessionInfo, 0);
            panel.add((Component)this.m_spURLTemplatePanel, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            buttonPanel = new JPanel(new FlowLayout(1, 4, 4));
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            buttonPanel.add((Component)this.m_OKButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.Help, VWResource.Help);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return buttonPanel;
    }
}

